#if !defined( _DIRECTIONALLIGHTS_FXH )
#define _DIRECTIONALLIGHTS_FXH

//---------------------------------------------------------------------------------
//
// Macros and definitions for directional lighting.
//

#define DECLARE_DIRECTIONAL_PARAMS( __count__ )		\
float3 lightDirection##__count__ : lightDirection	\
<																									\
	bool appEdit = false;														\
>;																								\
float4 lightColour##__count__ : lightColour				\
<																									\
	bool appEdit = false;														\
>;

#define DECLARE_DIRECTIONAL_INTERPOLATORS( __index__, __count__ )


#define DO_VS_DIRECTIONAL_LIGHTING_SETUP	\
	LPFLOAT3 VSDIR_lightVector;								\
	LPFLOAT3 VSDIR_eyeVector;								\
	LPFLOAT VSDIR_diffuseLevel;

#if !defined( _LIGHTING_PRECALCULATED_ )
	#define DO_VS_DIRECTIONAL_LIGHTING_CALCULATIONS( __count__ )
#else

		#define DO_VS_DIRECTIONAL_LIGHTING_CALCULATIONS( __count__ )																		\
			/* Calculate object coords light vector */																										\
			VSDIR_lightVector = -lightDirection##__count__;																								\
			VSDIR_eyeVector = normalize( worldEyeVec );																										\
																																																		\
			/* Calculate diffuse colour and add to accumulator */																					\
			VSDIR_diffuseLevel = CALCULATE_DIFFUSE_LIGHTING( normal, VSDIR_lightVector );									\
			_output.colour += max( VSDIR_diffuseLevel, 0.0f ) *																						\
												 lightColour##__count__ * ShadowLightLevel;																	\
																																																		\
			/* If the fragment faces the light source */																									\
			if ( VSDIR_diffuseLevel > SPECULAR_CUTOFF_LEVEL )																													\
			{																																															\
				/* Calculate specular colour and add to diffuse */																					\
				float specularPower = maxSpecPower;																													\
				_output.colour += CalculateSpecularLighting( normal, VSDIR_lightVector, VSDIR_eyeVector, specularPower ) *	\
													 lightColour##__count__ * globalSpecularFactorValue * ShadowLightLevel;												\
			}

#endif

#define DO_VERTEXLIGHTING_DIRECTIONAL_LIGHTING_CALCULATIONS( __worldNormal__, __accumulator__, __count__ )	\
		__accumulator__ += max( CALCULATE_DIFFUSE_LIGHTING( __worldNormal__, -lightDirection##__count__ ), 0.0f ) *  lightColour##__count__;


#if defined( USE_TRANSMISSIVE_LIGHTING )

#define DO_PS_DIRECTIONAL_LIGHTING_SETUP	\
	LPFLOAT3 PSDIR_lightVector;							\
	LPFLOAT PSDIR_diffuseLevel;							\
	LPFLOAT PSDIR_transLevel;

#else

#define DO_PS_DIRECTIONAL_LIGHTING_SETUP	\
	LPFLOAT3 PSDIR_lightVector;							\
	LPFLOAT PSDIR_diffuseLevel;

#endif


#if defined( USE_WARD_ANISOTROPIC_SPECULAR )

//
// Ward-style anisotropic lighting version
//
#define DO_PS_DIRECTIONAL_LIGHTING_CALCULATIONS( __accumulator__, __count__ )												\
	/* Calculate object coords light vector */																												\
	PSDIR_lightVector = -lightDirection##__count__;																										\
																																																		\
	/* Calculate diffuse colour and add to accumulator */																							\
	PSDIR_diffuseLevel = CALCULATE_DIFFUSE_LIGHTING( normal, PSDIR_lightVector );											\
	__accumulator__ += diffuseTexColour * max( PSDIR_diffuseLevel, 0.0f ) *														\
										 lightColour##__count__ * PSL_attenuation;																			\
																																																		\
	/* If the fragment faces the light source */																											\
	if ( PSDIR_diffuseLevel > SPECULAR_CUTOFF_LEVEL )																									\
	{																																																	\
		/* Calculate specular colour and add to diffuse */																							\
		__accumulator__ += specularTexColour *																													\
											 CalculateWardSpecularLighting( normal, perturbedUAxis, perturbedVAxis, alphaXValue, alphaYValue, PSDIR_lightVector, eye ) *	\
											 lightColour##__count__ * globalSpecularFactorValue * PSL_attenuation;							\
	}

#elif defined( USE_TRANSMISSIVE_LIGHTING )

	//
	// Blinn-style + transmissive lighting version
	//

	#if defined( _LIGHTING_PRECALCULATED_ )

		#define DO_PS_DIRECTIONAL_LIGHTING_CALCULATIONS( __accumulator__, __count__ )												\
			/* Calculate object coords light vector */																												\
			PSDIR_lightVector = -lightDirection##__count__;																										\
																																																				\
			/* Calculate diffuse level to see if specular is needed */																				\
			PSDIR_diffuseLevel = CALCULATE_DIFFUSE_LIGHTING( normal, PSDIR_lightVector );											\
																																																				\
			/* If the fragment faces the light source */																											\
			if ( PSDIR_diffuseLevel > SPECULAR_CUTOFF_LEVEL )																									\
			{																																																	\
				/* Calculate specular colour and add to diffuse */																							\
				float specularPower = lerp( minSpecPowerValue, maxSpecPowerValue, specularTexColour.a );									\
				__accumulator__ += specularTexColour *																													\
													 CalculateSpecularLighting( normal, PSDIR_lightVector, eye, specularPower ) *	\
													 lightColour##__count__ * globalSpecularFactorValue * PSL_attenuation;							\
			}

	#else // _LIGHTING_PRECALCULATED_

		#define DO_PS_DIRECTIONAL_LIGHTING_CALCULATIONS( __accumulator__, __count__ )												\
			/* Calculate object coords light vector */																												\
			PSDIR_lightVector = -lightDirection##__count__;																										\
																																																				\
			/* Calculate diffuse colour, transmitted colour and add blend them into accumulator */						\
			{	\
				float edotl = saturate( dot( eye, -PSDIR_lightVector ) );	\
				edotl *= edotl;	\
				PSDIR_diffuseLevel = CALCULATE_DIFFUSE_LIGHTING( normal, PSDIR_lightVector );										\
				float4 diffCol = diffuseTexColour * max( PSDIR_diffuseLevel, 0.0f ) * lightColour##__count__ * PSL_attenuation;	\
				PSDIR_transLevel = edotl * saturate( dot( -normal, PSDIR_lightVector ) * 0.6f + 0.4f );	\
				float4 transCol = transmissiveTexColour * max( PSDIR_transLevel, 0.0f ) * lightColour##__count__ * PSL_attenuation * transmissiveness;	\
				__accumulator__ += diffCol + transCol;	\
			}	\
																																																				\
			/* If the fragment faces the light source */																											\
			if ( PSDIR_diffuseLevel > SPECULAR_CUTOFF_LEVEL )																									\
			{																																																	\
				/* Calculate specular colour and add to diffuse */																							\
				float specularPower = lerp( minSpecPowerValue, maxSpecPowerValue, specularTexColour.a );									\
				__accumulator__ += specularTexColour *																													\
													 CalculateSpecularLighting( normal, PSDIR_lightVector, eye, specularPower ) *	\
													 lightColour##__count__ * globalSpecularFactorValue * PSL_attenuation;							\
			}

	#endif // _LIGHTING_PRECALCULATED_

#else

	//
	// Blinn-style lighting version
	//

	#if defined( _LIGHTING_PRECALCULATED_ )

		#define DO_PS_DIRECTIONAL_LIGHTING_CALCULATIONS( __accumulator__, __count__ )												\
			/* Calculate object coords light vector */																												\
			PSDIR_lightVector = -lightDirection##__count__;																										\
																																																				\
			/* Calculate diffuse level to see if specular is needed */																				\
			PSDIR_diffuseLevel = CALCULATE_DIFFUSE_LIGHTING( normal, PSDIR_lightVector );											\
																																																				\
			/* If the fragment faces the light source */																											\
			if ( PSDIR_diffuseLevel > SPECULAR_CUTOFF_LEVEL )																									\
			{																																																	\
				/* Calculate specular colour and add to diffuse */																							\
				float specularPower = lerp( minSpecPowerValue, maxSpecPowerValue, specularTexColour.a );									\
				__accumulator__ += specularTexColour *																													\
													 CalculateSpecularLighting( normal, PSDIR_lightVector, eye, specularPower ) *	\
													 lightColour##__count__ * globalSpecularFactorValue * PSL_attenuation;							\
			}

	#else // _LIGHTING_PRECALCULATED_

		#define DO_PS_DIRECTIONAL_LIGHTING_CALCULATIONS( __accumulator__, __count__ )												\
			/* Calculate object coords light vector */																												\
			PSDIR_lightVector = -lightDirection##__count__;																										\
																																																				\
			/* Calculate diffuse colour and add to accumulator */																							\
			PSDIR_diffuseLevel = CALCULATE_DIFFUSE_LIGHTING( normal, PSDIR_lightVector );											\
			__accumulator__ /*= PSL_attenuation;*/ += diffuseTexColour * max( PSDIR_diffuseLevel, 0.0f ) * lightColour##__count__ * PSL_attenuation;	\
																																																				\
			/* If the fragment faces the light source */																											\
			if ( PSDIR_diffuseLevel > SPECULAR_CUTOFF_LEVEL )																									\
			{																																																	\
				/* Calculate specular colour and add to diffuse */																							\
				float specularPower = lerp( minSpecPowerValue, maxSpecPowerValue, specularTexColour.a );									\
				__accumulator__ += specularTexColour *																													\
													 CalculateSpecularLighting( normal, PSDIR_lightVector, eye, specularPower ) *	\
													 lightColour##__count__ * globalSpecularFactorValue * PSL_attenuation;							\
			}

	#endif // _LIGHTING_PRECALCULATED_

#endif	// defined( USE_WARD_ANISOTROPIC_SPECULAR )

#endif	// !defined( _DIRECTIONALLIGHTS_FXH )
